<?php
// Ensure that the required parameters are received
if (isset($_GET['url']) && isset($_GET['email']) && isset($_GET['format']) && isset($_GET['suffix'])) {
    // Capture the parameters from the URL
    $long_url = urlencode($_GET['url']);
    $email = urlencode($_GET['email']);
    $format = urlencode($_GET['format']);
    $suffix = urlencode($_GET['suffix']);
    
    // Construct the target URL with parameters
    $shortening_url = "https://s.squizee.in/short/formResponse?url=$long_url&email=$email&format=$format&suffix=$suffix";

    // Initialize cURL session to send the request and get the response
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $shortening_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Return the response as a string
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);  // Follow redirects
    $response = curl_exec($ch);
    curl_close($ch);

    // Check if the response is valid and contains the shortened URL
    if ($response !== false) {
        $data = json_decode($response, true);
        
        if (isset($data['shortened_url'])) {
            // Replace 's.squizee.in' with the current host
            $current_host = $_SERVER['HTTP_HOST'];
            $shortened_url = str_replace('s.squizee.in', $current_host, $data['shortened_url']);

            // Remove 'http://', 'https://', and 'www.' from the URL
            $shortened_url = preg_replace('#^(https?://)?(www\.)?#', '', $shortened_url);

            // Set the response header to JSON
            header('Content-Type: application/json');
            
            // Return the shortened URL as JSON
            echo json_encode(['shortened_url' => $shortened_url]);
        } else {
            // Handle error if shortened_url is not present in the response
            header('Content-Type: application/json');
            echo json_encode(['error' => 'Could not get shortened URL']);
        }
    } else {
        // Handle cURL error
        header('Content-Type: application/json');
        echo json_encode(['error' => 'API request failed']);
    }
} else {
    // Handle missing parameters
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Missing required parameters']);
}
?>
